(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     15565,        402]
NotebookOptionsPosition[     14637,        379]
NotebookOutlinePosition[     14975,        394]
CellTagsIndexPosition[     14932,        391]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"SetDirectory", "[", 
    RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"Get", " ", "average", " ", "front", " ", "time", " ", "trace"}], 
   " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"m", "=", "80"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"result", "=", 
   RowBox[{"ConstantArray", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.", ",", "0.", ",", "0."}], "}"}], ",", "500"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"cfg", "=", "0."}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Do", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"analysis", "=", 
      RowBox[{"Import", "[", 
       RowBox[{
        RowBox[{"\"\<pars_\>\"", "<>", 
         RowBox[{"ToString", "[", 
          RowBox[{
           RowBox[{"n", "*", "100"}], "+", "m"}], "]"}], "<>", 
         "\"\</rng_\>\"", "<>", 
         RowBox[{"ToString", "[", "k", "]"}], "<>", "\"\</Analysis.h5\>\""}], 
        ",", "\"\</FrontPosition\>\""}], "]"}]}], ";", "\[IndentingNewLine]", 
     
     RowBox[{
      RowBox[{"result", "[", 
       RowBox[{"[", 
        RowBox[{";;", ",", "1"}], "]"}], "]"}], "+=", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"\"\<Count\>\"", "*", "\"\<Mean\>\""}], ")"}], "/.", 
       "analysis"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"result", "[", 
       RowBox[{"[", 
        RowBox[{";;", ",", "2"}], "]"}], "]"}], "+=", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"\"\<Count\>\"", "*", 
         RowBox[{"(", 
          RowBox[{"\"\<Variance\>\"", "+", 
           RowBox[{"\"\<Mean\>\"", "^", "2"}]}], ")"}]}], ")"}], "/.", 
       "analysis"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"result", "[", 
       RowBox[{"[", 
        RowBox[{";;", ",", "3"}], "]"}], "]"}], "+=", 
      RowBox[{
       RowBox[{"(", "\"\<Count\>\"", ")"}], "/.", "analysis"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"cfg", "+=", 
      RowBox[{"ToExpression", "[", 
       RowBox[{"\"\<SUBSTRATE_DISSIPATION\>\"", "/.", 
        RowBox[{"(", 
         RowBox[{"\"\<CELL\>\"", "/.", 
          RowBox[{"Import", "[", 
           RowBox[{"\"\<pars_\>\"", "<>", 
            RowBox[{"ToString", "[", 
             RowBox[{
              RowBox[{"n", "*", "100"}], "+", "m"}], "]"}], "<>", 
            "\"\</rng_\>\"", "<>", 
            RowBox[{"ToString", "[", "k", "]"}], "<>", 
            "\"\</config.json\>\""}], "]"}]}], ")"}]}], "]"}]}], ";"}], 
    "\[IndentingNewLine]", ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "0", ",", "9"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"k", ",", "10"}], "}"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"result", "[", 
    RowBox[{"[", 
     RowBox[{";;", ",", "1"}], "]"}], "]"}], "/=", 
   RowBox[{"result", "[", 
    RowBox[{"[", 
     RowBox[{";;", ",", "3"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"result", "[", 
    RowBox[{"[", 
     RowBox[{";;", ",", "2"}], "]"}], "]"}], "/=", 
   RowBox[{"result", "[", 
    RowBox[{"[", 
     RowBox[{";;", ",", "3"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"result", "[", 
    RowBox[{"[", 
     RowBox[{";;", ",", "2"}], "]"}], "]"}], "-=", 
   RowBox[{
    RowBox[{"result", "[", 
     RowBox[{"[", 
      RowBox[{";;", ",", "1"}], "]"}], "]"}], "^", "2"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"cfg", "/=", "100"}], ";"}]}], "Input",
 CellChangeTimes->{
  3.7498187558942633`*^9, {3.749818787198708*^9, 3.7498187886729193`*^9}, {
   3.751371489442762*^9, 3.7513714926886587`*^9}, {3.7765372655856*^9, 
   3.776537267109116*^9}, {3.776537413062283*^9, 
   3.776537419147039*^9}},ExpressionUUID->"c9c001ea-12bd-4102-bb53-\
5547682c7cc1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Get", " ", "dissipation", " ", "Mean"}], "*)"}], 
  "\[IndentingNewLine]", "cfg"}]], "Input",
 CellChangeTimes->{{3.7498189694374866`*^9, 3.749818969825807*^9}, {
   3.7765372781405888`*^9, 3.7765372787561073`*^9}, 
   3.776537419148158*^9},ExpressionUUID->"eb8b695e-1d84-4f58-8fca-\
8d3f3dae3d00"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Export", " ", "time", " ", "trace"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"Export", "[", 
   RowBox[{"\"\<~/Downloads/tissue_D_20.dat\>\"", ",", "result"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.749818942527513*^9, 3.749819016898625*^9}, {
  3.749983983699026*^9, 3.749984044253263*^9}, {3.7513714977171717`*^9, 
  3.7513715001117077`*^9}, {3.751371532582006*^9, 3.75137155917213*^9}, {
  3.776537283800156*^9, 
  3.77653728464778*^9}},ExpressionUUID->"860367a0-f66b-4b75-bbfc-\
60a83db59b38"],

Cell[BoxData["\<\"~/Downloads/tissue_D_20.dat\"\>"], "Output",
 CellChangeTimes->{{3.7498189632432756`*^9, 3.7498190203662443`*^9}, {
   3.749983986550441*^9, 3.7499840454589663`*^9}, 3.7513715004827433`*^9, {
   3.751371533195045*^9, 3.7513715596300993`*^9}},
 CellLabel->"Out[87]=",ExpressionUUID->"20b39913-1666-40bf-866d-27fc0be386b1"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"SetDirectory", "[", 
    RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Get", " ", "tissue", " ", "properties", " ", "depending", " ", "on", " ", 
    "substrate", " ", "dissipation"}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"resultarray", "=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Monitor", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"finalresult", "=", 
     RowBox[{"Table", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"result", "=", 
         RowBox[{"ConstantArray", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0.", ",", "0.", ",", "0."}], "}"}], ",", "500"}], 
          "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"cfg", "=", "0."}], ";", "\[IndentingNewLine]", 
        RowBox[{"Do", "[", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"analysis", "=", 
            RowBox[{"Import", "[", 
             RowBox[{
              RowBox[{"\"\<pars_\>\"", "<>", 
               RowBox[{"ToString", "[", 
                RowBox[{
                 RowBox[{"n", "*", "100"}], "+", "m"}], "]"}], "<>", 
               "\"\</rng_\>\"", "<>", 
               RowBox[{"ToString", "[", "k", "]"}], "<>", 
               "\"\</Analysis.h5\>\""}], ",", "\"\</FrontPosition\>\""}], 
             "]"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"result", "[", 
             RowBox[{"[", 
              RowBox[{";;", ",", "1"}], "]"}], "]"}], "+=", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"\"\<Count\>\"", "*", "\"\<Mean\>\""}], ")"}], "/.", 
             "analysis"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"result", "[", 
             RowBox[{"[", 
              RowBox[{";;", ",", "2"}], "]"}], "]"}], "+=", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"\"\<Count\>\"", "*", 
               RowBox[{"(", 
                RowBox[{"\"\<Variance\>\"", "+", 
                 RowBox[{"\"\<Mean\>\"", "^", "2"}]}], ")"}]}], ")"}], "/.", 
             "analysis"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"result", "[", 
             RowBox[{"[", 
              RowBox[{";;", ",", "3"}], "]"}], "]"}], "+=", 
            RowBox[{
             RowBox[{"(", "\"\<Count\>\"", ")"}], "/.", "analysis"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"cfg", "+=", 
            RowBox[{"ToExpression", "[", 
             RowBox[{"\"\<SUBSTRATE_DISSIPATION\>\"", "/.", 
              RowBox[{"(", 
               RowBox[{"\"\<CELL\>\"", "/.", 
                RowBox[{"Import", "[", 
                 RowBox[{"\"\<pars_\>\"", "<>", 
                  RowBox[{"ToString", "[", 
                   RowBox[{
                    RowBox[{"n", "*", "100"}], "+", "m"}], "]"}], "<>", 
                  "\"\</rng_\>\"", "<>", 
                  RowBox[{"ToString", "[", "k", "]"}], "<>", 
                  "\"\</config.json\>\""}], "]"}]}], ")"}]}], "]"}]}], ";"}], 
          "\[IndentingNewLine]", ",", 
          RowBox[{"{", 
           RowBox[{"n", ",", "0", ",", "9"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"k", ",", "10"}], "}"}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"result", "[", 
          RowBox[{"[", 
           RowBox[{";;", ",", "1"}], "]"}], "]"}], "/=", 
         RowBox[{"result", "[", 
          RowBox[{"[", 
           RowBox[{";;", ",", "3"}], "]"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"result", "[", 
          RowBox[{"[", 
           RowBox[{";;", ",", "2"}], "]"}], "]"}], "/=", 
         RowBox[{"result", "[", 
          RowBox[{"[", 
           RowBox[{";;", ",", "3"}], "]"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"result", "[", 
          RowBox[{"[", 
           RowBox[{";;", ",", "2"}], "]"}], "]"}], "-=", 
         RowBox[{
          RowBox[{"result", "[", 
           RowBox[{"[", 
            RowBox[{";;", ",", "1"}], "]"}], "]"}], "^", "2"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"cfg", "/=", "100"}], ";", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"AppendTo", "[", 
         RowBox[{"resultarray", ",", "result"}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"cfg", ",", 
          RowBox[{"Max", "@", 
           RowBox[{"result", "[", 
            RowBox[{"[", 
             RowBox[{
              RowBox[{"200", ";;", 
               RowBox[{"-", "1"}]}], ",", "1"}], "]"}], "]"}]}], ",", 
          RowBox[{"Max", "@", 
           RowBox[{"result", "[", 
            RowBox[{"[", 
             RowBox[{
              RowBox[{"200", ";;", 
               RowBox[{"-", "1"}]}], ",", "2"}], "]"}], "]"}]}], ",", 
          RowBox[{"Mean", "[", 
           RowBox[{
            RowBox[{"Sqrt", "@", 
             RowBox[{"result", "[", 
              RowBox[{"[", 
               RowBox[{
                RowBox[{"200", ";;", 
                 RowBox[{"-", "1"}]}], ",", "2"}], "]"}], "]"}]}], "/", 
            RowBox[{"result", "[", 
             RowBox[{"[", 
              RowBox[{
               RowBox[{"200", ";;", 
                RowBox[{"-", "1"}]}], ",", "1"}], "]"}], "]"}]}], "]"}]}], 
         "}"}]}], "\[IndentingNewLine]", "\[IndentingNewLine]", ",", 
       RowBox[{"{", 
        RowBox[{"m", ",", "0", ",", "99"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", "n", ",", "k"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.7469611432785597`*^9, 3.746961144276451*^9}, {
   3.746965281869259*^9, 3.746965459873785*^9}, {3.746965498987928*^9, 
   3.746965667889323*^9}, {3.7469748860070477`*^9, 3.74697491872473*^9}, {
   3.746974949416271*^9, 3.7469750794926558`*^9}, {3.7469751268254347`*^9, 
   3.746975131510262*^9}, {3.746975184142248*^9, 3.746975208871375*^9}, {
   3.7469752432553988`*^9, 3.7469752435576773`*^9}, {3.746975275545196*^9, 
   3.746975300213953*^9}, {3.746975811139539*^9, 3.746975835250311*^9}, {
   3.747295250876471*^9, 3.7472952543825197`*^9}, {3.7472953335387707`*^9, 
   3.7472954302408648`*^9}, {3.74729549143955*^9, 3.747295505649798*^9}, {
   3.7472955479207067`*^9, 3.7472955700068283`*^9}, {3.747295608263852*^9, 
   3.747295624632111*^9}, {3.747295696061473*^9, 3.7472957039784718`*^9}, {
   3.747295856557472*^9, 3.7472958576972857`*^9}, {3.747462376603374*^9, 
   3.7474623972365522`*^9}, {3.7475423561524973`*^9, 3.747542360860826*^9}, {
   3.749484816344467*^9, 3.74948482186034*^9}, {3.749484912770645*^9, 
   3.749485064468494*^9}, {3.7494854510000553`*^9, 3.749485454495776*^9}, {
   3.7494855579559803`*^9, 3.749485558916917*^9}, {3.749485598799759*^9, 
   3.749485604805133*^9}, 3.7495270040525913`*^9, {3.749993286865794*^9, 
   3.7499933038901787`*^9}, {3.7513635821639853`*^9, 3.751363597089436*^9}, {
   3.7765372980154953`*^9, 3.776537336855966*^9}, {3.776537413064662*^9, 
   3.7765374191529007`*^9}},ExpressionUUID->"4fcce424-4313-4a2d-877b-\
803122798cb3"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Export", " ", "data"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"#1", " ", "Substrate", " ", "dissipation"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"#2", " ", "maximum", " ", "expansion"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"#3", " ", "maximum", " ", "variance"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"#4", " ", "average", " ", "roughness", " ", 
    RowBox[{"(", 
     RowBox[{
     "standard", " ", "deviation", " ", "relative", " ", "to", " ", 
      "expanion"}], ")"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"Export", "[", 
   RowBox[{"\"\<~/Downloads/tissue_D.dat\>\"", ",", "finalresult"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.7474636050837317`*^9, 3.747463613504825*^9}, {
  3.747463657079228*^9, 3.747463667162775*^9}, {3.7495269934278727`*^9, 
  3.74952699366398*^9}, {3.7513714638387213`*^9, 3.751371464111505*^9}, {
  3.776537348799835*^9, 
  3.776537355489724*^9}},ExpressionUUID->"1cd23770-9341-46f0-9e68-\
a2f83469e71d"],

Cell[BoxData["\<\"~/Downloads/tissue_D.dat\"\>"], "Output",
 CellChangeTimes->{3.747463667700366*^9, 3.749527593185503*^9, 
  3.749983962022409*^9, 3.74999408225817*^9, 3.749994306990736*^9, 
  3.751371464589746*^9},
 CellLabel->"Out[25]=",ExpressionUUID->"296606a0-d2f4-46d4-a467-92a39462e5f7"]
}, Open  ]]
},
WindowSize->{808, 656},
WindowMargins->{{Automatic, 97}, {-11, Automatic}},
FrontEndVersion->"12.0 for Mac OS X x86 (64-bit) (April 8, 2019)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 3985, 114, 472, "Input",ExpressionUUID->"c9c001ea-12bd-4102-bb53-5547682c7cc1"],
Cell[4546, 136, 356, 8, 52, "Input",ExpressionUUID->"eb8b695e-1d84-4f58-8fca-8d3f3dae3d00"],
Cell[CellGroupData[{
Cell[4927, 148, 567, 13, 52, "Input",ExpressionUUID->"860367a0-f66b-4b75-bbfc-60a83db59b38"],
Cell[5497, 163, 339, 4, 34, "Output",ExpressionUUID->"20b39913-1666-40bf-866d-27fc0be386b1"]
}, Open  ]],
Cell[5851, 170, 7298, 169, 598, "Input",ExpressionUUID->"4fcce424-4313-4a2d-877b-803122798cb3"],
Cell[CellGroupData[{
Cell[13174, 343, 1149, 27, 136, "Input",ExpressionUUID->"1cd23770-9341-46f0-9e68-a2f83469e71d"],
Cell[14326, 372, 295, 4, 34, "Output",ExpressionUUID->"296606a0-d2f4-46d4-a467-92a39462e5f7"]
}, Open  ]]
}
]
*)

